//********************************************************************
//  ColoredCircles.java       Author: Lewis and Loftus
//
//  Solution to Programming Project 5.22 (5E, p. 288)
//********************************************************************

import javax.swing.JApplet;
import java.awt.*;

public class ColoredCircles extends JApplet
{
   private final int NUM_CIRCLES = 100;
   private final int MIN_DIAMETER = 5;
   private final int MAX_DIAMETER = 30;
   private final int MAX_COLORVALUE = 256;
   private final int MAX_X = 370;
   private final int MAX_Y = 170;

   //-----------------------------------------------------------------
   //  Paints several circles of random color, diameter, and location.
   //-----------------------------------------------------------------
   public void paint(Graphics page)
   {
      int x, y, diameter, red, green, blue;

      setBackground (Color.black);

      for (int count=1; count <= NUM_CIRCLES; count++)
      {
         x = (int) (Math.random() * MAX_X);
         y = (int) (Math.random() * MAX_Y);

         red = (int) (Math.random() * MAX_COLORVALUE);
         green = (int) (Math.random() * MAX_COLORVALUE);
         blue = (int) (Math.random() * MAX_COLORVALUE);
         page.setColor (new Color(red, green, blue));

         diameter = (int) (Math.random() * MAX_DIAMETER) + MIN_DIAMETER;

         page.drawOval (x, y, diameter, diameter);
      }
   }
}
